void restartPico();   //再起動

extern unsigned long start_time;
extern String ssid;
extern String password;
extern String host;
extern String token;

/*「Raspberry Pi Pico W」が対応しているWi-Fiの規格は次の通りです。
対応規格　：　2.4GHz 802.11 b/g/n
規格のうち、2.4GHz帯を使う形となります。
;-------
あらかじめ自宅のWi-FiのSSIDとパスワードを調べておきましょう。
Pico Wは2.4GHz帯のWi-Fiにのみ対応しており、5GHz帯のWi-Fiは使用
できませんので注意しましょう。*/

void ConectingWiFi() {
  display(0, 40, "WiFi への接続を実行しています。");
  start_time = millis(); //実行時間計測用
  WiFi.disconnect(true);
  WiFi.persistent(false);
  WiFi.mode(WIFI_STA);
  WiFi.begin(ssid.c_str(), password.c_str()); //WiFi の利用開始

  Serial.print("Connecting to Wi-Fi");
  int retryCount = 0;
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    //Serial.printf("Retry %d: Status = %d\n", retryCount, WiFi.status());  //モニター
    Serial.print(".");
    retryCount++;
    if (retryCount > 40) {  // 0.5x40=20秒待っても接続できなかったら再起動
        Serial.println("\nWi-Fi 接続失敗。リブートします...");
        display(0, 15, "WiFi接続が失敗!\n"
                      "リブートします。\n"
                      "SSID,passwordの\n"
                      "再確認が必要かも\n"
                      "しれません。");
        delay(5000);
        restartPico();
    }
  }
  Serial.println("\nConnected to Wi-Fi");
  Serial.println((double)(millis() - start_time) / 1000.0); //接続完了までの時間
}

/*電源ON時 　　　→ DNS名前解決 + NTPパケット送信と受信 → すべてを最初から実行(2～3秒)
　稼働中の校正時 → DNS キャッシュも有効 → NTPクエリが即実行されて即応答が返る(0.1秒)
　SNTPクライアント（NTPクライアント）の設計仕様による
*/
// NTPサーバーリスト
const char* ntpServers[] = {
  "ntp.jst.mfeed.ad.jp",  //"210.173.160.27"
  "ntp.nict.jp",          //"133.243.238.244"
  "time.google.com",      //"216.239.35.0"
  "pool.ntp.org"          //"162.159.200.1"
  "gps.kek.jp"            //"130.87.32.71"
};

const int numServers = sizeof(ntpServers) / sizeof(ntpServers[0]);
const char* NTPSRV = nullptr; // 選択されたNTPサーバー(使用されていない)
const long GMT_OFFSET = 9;    // GMTオフセット(国際標準時と日本標準時の差)
int DayS;                     // setClockを起動したときの日を記録
extern int FixFrepF;          //定時通報を実行したフラグ

void setClock(int flg) {
  char buf[64]; 

  bool success = false;
  display(0, 40, "SNTPから時刻の取得をしています。");
  unsigned long start_time = millis(); //実行時間計測用
  for (int i = 0; i < numServers; i++) {
    Serial.print("Trying NTP server: ");
    Serial.println(ntpServers[i]);

    NTP.begin(ntpServers[i]);

    if (NTP.waitSet(20 * 1000)) {   //20秒 TimeOut
      success = true;
      NTPSRV = ntpServers[i];
      break;
    }
    Serial.println("NTP sync failed, trying next server...");
  }

  if (!success) {
    Serial.println("All NTP servers failed! Do reboot ...");
    restartPico();
    //setTime(0, 0, 0, 1, 1, 1970);
    //return;
  }

  // 1970年だったら再試行（最大20回リトライ）
  time_t now = time(nullptr);   //「NTPを使うと time_t に設定されている」 ことに注意！
  int retry = 0;
  while (now < 1000000000 && retry < 20) {  //nowは動いているので20秒間様子を見る
    Serial.println("Waiting for valid time...");
    delay(1000);
    now = time(nullptr);
    retry++;
  }
  // 最終チェック
  if (now < 1000000000) {
    Serial.println("時刻取得に失敗しました。再起動します...");
    restartPico();
  }

  // 最後にRTCの時間を日本標準時に変換して格納する
  struct tm timeinfo;
  gmtime_r(&now, &timeinfo);

  setTime(timeinfo.tm_hour, timeinfo.tm_min, timeinfo.tm_sec,
          timeinfo.tm_mday, timeinfo.tm_mon + 1, timeinfo.tm_year + 1900);
  adjustTime(GMT_OFFSET * SECS_PER_HOUR);

  Serial.print("Current time: ");
  sprintf(buf, " %04d-%02d-%02d %02d:%02d:%02d\n",
          year(), month(), day(), hour(), minute(), second());
  Serial.print(buf);
  DayS = (int)day();      //この関数が実行された時の日付を記録する
  Serial.println((double)(millis() - start_time) / 1000.0); //時刻取得までの時間
  FixFrepF = 0; // 追加：時刻補正後、再送信フラグをリセットする(定時通報停止の回避)
  if (flg) delay(3000);   //Displayの表示を見せる
}

// LINE送出の本体部
boolean line_notify(String msg) {
  WiFiClientSecure client;  // HTTPSへアクセス（SSL通信）するためのライブラリ
  client.setInsecure();     // サーバー証明書の検証を行わずに接続する場合に必要

  if(!client.connect(host.c_str(), 443)) {  //LineのAPIサーバにSSL接続（ポート443:https）
    Serial.println("Line HTTPS connect error!"); //これが時々でるのでRetryが必要と思える
    return false;
  }
  Serial.println("HTTPS Connected");
  String query = String("{\"messages\":[{\"type\":\"text\",\"text\":\"") + msg + "\"}]}";
  String request = String("")
              + "POST /v2/bot/message/broadcast HTTP/1.1\r\n"
              + "Host: " + host.c_str() + "\r\n"
              + "Authorization: Bearer " + token.c_str() + "\r\n"
              + "Content-Length: " + String(query.length()) + "\r\n"
              + "Content-Type: application/json\r\n\r\n"
              + query + "\r\n";
  client.print(request);
  //Serial.println(request.c_str());
  // 受信完了まで待機 
  while (client.connected()) {
    String line = client.readStringUntil('\n');
    if (line == "\r") break;
  }
  String line = client.readStringUntil('\n');
  Serial.println(line);
  if (line.indexOf("}") == -1) {
    Serial.println("No response error!");  //応答が無ければ送っていないと考えられる
    return false;   //見つからなければfalseを返す
  } else {
    if(line.length() >= 5) {
      display(0, 0, line);    //Line からメッセージを表示する
      delay(5000);  //while (BOOTSEL == 0) {}
    }
  }
  return true;
}

extern char buf[], buf2[];        // sprintf用のBuffer
extern float temp, hum, pres;
extern int NoLineFlg;
int LineKind = 0;
void saveNoLineFlg(int flg);

void SendToLine() {   // LINE送出の先駆部
    sprintf(buf2, "%04d-%02d-%02d %02d:%02d:%02d",
        year(), month(), day(), hour(), minute(), second());  
    if ((LineKind == 1) || (NoLineFlg == 2)) {  //定時通報 or 定時通報Restart & Retry 
      sprintf(buf,"%s\\n環境の定時通報：\\n温度:%.1f℃, 湿度:%.1f％,"
                                      "\\n気圧:%.0fhPa",buf2,temp,hum,pres);
    // \n を \\n に変更することで、JSONの構造を壊さずに改行を含むメッセージが送れる
    } else {
      sprintf(buf,"%s\\nこの時点の環境：\\n温度:%.1f℃, 湿度:%.1f％,"
                                      "\\n気圧:%.0fhPa",buf2,temp,hum,pres);
    }
    String Message = buf;
    Serial.printf("Message:%s\n", Message.c_str());
    display(0, 40, "LINEへメッセージを送っています。");
    start_time = millis(); //実行時間計測用
    int retryCount = 0;
    while (line_notify(Message) != true) {  //LINE送出本体呼び出し(Retryを追加)
      delay(1000);
      retryCount++;
      if (retryCount >= 5) {  // 5回接続できなかったら再起動
          Serial.println("\nLine HTTPS接続失敗。リブートします...");
          if (LineKind == 0) saveNoLineFlg(1);   // NoLineFlg=1をFileにSave、次回に再送
          else saveNoLineFlg(2);   // NoLineFlg=2をFileにSave(定時通報)、次回に再送
          restartPico();
      }
    }
    LineKind = 0;
    Serial.println((double)(millis() - start_time) / 1000.0); //Line完了までの時間
}
/*2025-04-25 06:00:44    |  2025-04-25 06:00:53　　　　restartPico()後、一回目は44秒遅れ
  環境の定時通報          |  環境の定時通報             9秒遅れで再送しているのは何故？
  温度:23.2℃, 湿度:45.7%,|  温度:23.2℃, 湿度:45.7%,　一回目が完全完了しなかったが送出は
  気圧:1012hpa            |  気圧:1012hpa              されたのではないか・・停止よりまし*/

int TmNow;              //現在の時間(分)
int TmNowA;
int FixFrepF = 0;       //定時通報を実行したフラグ
int TmPrep = 0;         //前回、定時通報を実行した時間
extern int TmStart;     //起点時間
extern int TmInterval;  //1日1回(1440)、1日2回(720)

bool FixTmMes() {   //定時通報のチェック
  TmNowA = TmNow = hour() * 60 + minute(); //分換算

  // ▼ 追加：時刻ジャンプ対策（例えば1時間以上ズレていたらリセット）
  if ((TmNowA - TmPrep >= 60) || (TmNowA < TmPrep)) {
    FixFrepF = 0;
  }

  if (TmNow < TmStart) TmNowA = TmNow + 1440;       // この２行でないと TmStartで始まらず
  if ((((TmNowA - TmStart) % TmInterval) == 0)) {   // ０から始まる(Pythonでシミュレート)
    if (FixFrepF == 0) {
      FixFrepF = 1;  //同じ分の間は再送しないように抑制
      TmPrep = TmNow;  //TmNowAは加算しているので元の時間を代入
      LineKind = 1;
      return true;
    }
  } else {
    FixFrepF = 0; LineKind = 0;
  }

  return false;
}
