#include <Arduino.h>
#include <fstream>    //転送を制御するストリーム バッファーを記述
#include <sstream>    //標準ストリームに対する読み取りと書き込みを制御する
#include <vector>     //vector コンテナは可変長配列として実装される

#define BOOL_TO_STRING(b) ((b) ? "true" : "false")
extern String ssid;      //WiFiのssid
extern String password;  //WiFiのPassWord
extern String token;     //LINEのトークン
extern const String FileVersion; //File Version
extern int TmStart;      //起点時間(分)
extern int TmInterval;   //間隔(分)
extern int Reserve;      //予備
extern int NoLineFlg;    //前回Line送出に失敗したFlag

File file;
String RDat;

void saveSecrets(String id, String paswd, String tokn) {
    file = LittleFS.open("/secrets.dat", "w"); //"w"上書きモード
    if (!file) {
        Serial.println("Failed to open file for writing");
        return;
    }
    file.println(id.c_str());     // 1行目
    file.println(paswd.c_str());  // 2行目
    file.println(token.c_str());  // 3行目
    file.close();
}

void loadSecrets() {
    file = LittleFS.open("/secrets.dat", "r");
    if (!file) {
        Serial.println("Failed to open file for reading");
        return;
    }
    //ここで、ssid,password,token が書き換えられる
    ssid = file.readStringUntil('\n');      // 1行目
    password = file.readStringUntil('\n');  // 2行目
    token = file.readStringUntil('\n');     // 3行目
    file.close();
    ssid.trim(); password.trim(); token.trim(); //注！改行削除

    /*Serial.println("Secrets loaded:");
    Serial.print("SSID: "); Serial.println(ssid);
    Serial.print("Password: "); Serial.println(password);
    Serial.print("Token: "); Serial.println(token);*/
}

void saveSecretsBackup() {  //secrets.dat -> secrets.bku
    file = LittleFS.open("/secrets.dat", "r");
    if (!file) {
        Serial.println("Failed to open file for reading");
        return;
    }
    //ここで、ssid,password,token が書き換えられる
    String id = file.readStringUntil('\n');      // 1行目
    String paswd = file.readStringUntil('\n');   // 2行目
    String tken = file.readStringUntil('\n');    // 3行目
    file.close();
    id.trim(); paswd.trim(); tken.trim(); //注！改行削除

    file = LittleFS.open("/secrets.bku", "w"); //"w"上書きモード
    if (!file) {
        Serial.println("Failed to open file for writing");
        return;
    }
    file.println(id.c_str());     // 1行目
    file.println(paswd.c_str());  // 2行目
    file.println(tken.c_str());   // 3行目
    file.close();
}

void restoreSecretsBackup() {  //secrets.bku -> secrets.dat
    file = LittleFS.open("/secrets.bku", "r");
    if (!file) {
        Serial.println("Failed to open file for reading");
        return;
    }
    //ここで、ssid,password,token が書き換えられる
    String id = file.readStringUntil('\n');      // 1行目
    String paswd = file.readStringUntil('\n');   // 2行目
    String tken = file.readStringUntil('\n');    // 3行目
    file.close();
    id.trim(); paswd.trim(); tken.trim(); //注！改行コード削除

    file = LittleFS.open("/secrets.dat", "w"); //"w"上書きモード
    if (!file) {
        Serial.println("Failed to open file for writing");
        return;
    }
    file.println(id.c_str());     // 1行目
    file.println(paswd.c_str());  // 2行目
    file.println(tken.c_str());   // 3行目
    file.close();
}

void saveParameters(int tmstart, int tmintval, int reserve) {
    file = LittleFS.open("/parameter.dat", "w");
    if (!file) {
        Serial.println("Failed to open file for writing");
        return;
    }
    file.printf("%d,%d,%d\n", tmstart, tmintval, reserve);
    file.close();
}

void loadParameters() {
    file = LittleFS.open("/parameter.dat", "r");
    if (!file) {
        Serial.println("Failed to open file for reading");
        return;
    }
    
    String content = file.readStringUntil('\n'); // 1行読み取る
    //Serial.printf("content:%s\n", content.c_str()); //100,200,0
    file.close();
    sscanf(content.c_str(), "%d,%d,%d", &TmStart, &TmInterval, &Reserve);
    //TmStart などの変数は、値渡しではなくポインタとして渡す必要があります
    /*Serial.println("Parameters loaded:");
    Serial.print("TmStart: "); Serial.println(TmStart);
    Serial.print("TmInterval: "); Serial.println(TmInterval);
    Serial.print("Reserve: "); Serial.println(Reserve);*/
}

void listFiles() {
  Dir dir = LittleFS.openDir("/");
  // or Dir dir = LittleFS.openDir("/data");
  Serial.println("------- Dir --------");
  while (dir.next()) {
    Serial.print(dir.fileName() + " size:");
    if(dir.fileSize()) {
        File f = dir.openFile("r");
        Serial.println(f.size());
    }
  }
  Serial.println("--------------------");
}

void saveVersion() {
  file = LittleFS.open("/version.txt", "w");
  if (file) {
      file.println(FileVersion); //書き込みＯＫ
      file.close();
  }
}

void loadVersion() {
  file = LittleFS.open("/version.txt", "r");
  if (file) {
    Serial.print("File Version: ");
    while (file.available()) {
      RDat = file.readString(); // ファイルの内容全体を取得
    }
    file.close();
    Serial.println(RDat);
  }
}

void saveNoLineFlg(int flg) {   //Line 送出エラー 0/1
    file = LittleFS.open("/nolineflg.dat", "w");
    if (!file) {
        Serial.println("Failed to open file for writing");
        return;
    }
    file.printf("%d", flg);
    file.close();
}

void loadNoLineFlg() {
    file = LittleFS.open("/nolineflg.dat", "r");
    if (!file) {
        Serial.println("Failed to open file for reading");
        return;
    }
    String content = file.readString(); //ファイル内容を取得
    file.close();
    NoLineFlg = atoi(content.c_str());
}

//全ファイル(test.txt, secrets.dat, parameter.dat)のW/Rテスト
void FileWRtest() {   //ファイル読み書きのテスト

  // test.txtファイルに書き込み
  /*file = LittleFS.open("/test.txt", "w");
  if (file) {
      file.println("Hello, Pico W!"); //書き込みＯＫ
      file.close();
  }*/

  // test.txtファイルを読み込み
  /*file = LittleFS.open("/test.txt", "r");
  if (file) {
    Serial.print("Reading from test.txt:");
    while (file.available()) {
      //Serial.write(file.read());  //先頭の文字(int)を返してくる
      RDat = file.readString();     // ファイルの内容全体を取得
    }
    file.close();
    Serial.println(RDat);  // Reading from test.txt:Hello, Pico W!
  }*/

  // version.txtファイルに書込・読出し
  //saveVersion();
  loadVersion();

  //secrets.datのテスト
  //saveSecrets(ssid, password, token); //動作ＯＫ
  //loadSecrets();  //setup()に入れた
  /*Secrets loaded:
    SSID: SPWH_L13_74C08E
    Password: 5jS64tHX
    Token: 3EuGNxZToB+VRCTnaN/zb6NTlXMcSozrEzpYG6s1Xc
    blAxIOEkIajIVkxs21+JdH8LrQCwSHGDPJaQ4aT4YyRK/cnrksK9OM6ZUlPxVTcfv
    uglcQOkI+6t2dql8DJpOmSgy81MpwAAA4aEuXmN0IFwdB04t89/1O/w1cDnyilFU=
    確かに保存されている！
  */

  // Parameterの書き込みと読み出し
  //saveParameters(TmStart, TmInterval, Reserve);
  //loadParameters();  //setup()に入れた
  /*Parameters loaded:
    TmStart: 480
    TmInterval: 720
    Reserve: 0
  */
  //loadNoLineFlg();
    /*if (LittleFS.exists("/parameter.dat")) {
      Serial.println("parameter.dat は存在します");
  } else {
      Serial.println("parameter.dat は存在しません");
  }
  if (LittleFS.exists("/test.txt")) {
      Serial.println("test.txt は存在します");
  } else {
      Serial.println("test.txt は存在しません");
  }*/

//ファイルのリスト取得
  listFiles();
  /* https://arduino-pico.readthedocs.io/en/latest/fs.html
    ------- Dir --------
    parameter.dat size:10
    secrets.dat size:201
    test.txt size:16
    version.txt size:26
    --------------------
  */
}

//=============  RS232C通信のための関数群  =============

uint32_t gpio_state;

void printBinary(uint32_t value, int bits) {  //bits:表示するbit数
    for (int i = bits - 1; i >= 0; i--) {
        Serial.print((value >> i) & 1);
    }
    Serial.println();
}

uint GetSWstate() {  //SWの状態を下3bitに集約して返す(Portの状態、Pressで0)
  uint32_t gpio_state = sio_hw->gpio_in;  //全GPIO の状態を取得(*sio_hw).gpio_in

  uint8_t sw_states = ((gpio_state >> SW1) & 1) << 2 |  // SW1(SET) をビット2に
                      ((gpio_state >> SW2) & 1) << 1 |  // SW2(UP)  をビット1に
                      ((gpio_state >> SW3) & 1) << 0;   // SW3 (DW) をビット0に
  return (uint)sw_states;
}

bool ChkAllSWPress(int ts) {  //3個のSWが一緒に ts(ms)以上押すとtrueを返す
	unsigned long st = millis();
	bool flg = false; unsigned long tm = 0;

  while ((GetSWstate() & 7) == 0) {	// 3個のSWが押されている
		tm = millis() - st;
		if (tm >= ts) {flg = true; break; }   //押しがts(ms)続いた
	}
  return flg;
}

bool ChkSWNoChatt(int idx, int ts) {  //idx:2,1,0(bit) ts(ms)以上押すとtrueを返す
	unsigned long st = millis();
	bool flg = false; unsigned long tm = 0;

  while ((GetSWstate() & (1 << idx)) == 0) {	// Set SW が押されている
		tm = millis() - st;
		if (tm >= ts) {flg = true; break; }   //押しがts(ms)続いた
	}
  return flg;
}

int StateSetSW(int slf) {		// 10～300msで1、300ms～で2、2or5Secで3、以外は0を返す
	unsigned long st = millis();
	int flag = 0; unsigned long tm = 0;
	unsigned long tout;
	if (slf == 0) tout = 2000; else tout = 5000;

	while ((GetSWstate() & 4) == 0) {	// Set SW が押されている
		tm = millis() - st;
		if ((GetSWstate() & 0b100) != 0) break;	// SW Off
		if (tm >= tout) {flag = 3; break; }		  // Press 2or5秒
	}
	if ((tm >= 10) && (tm < 300)) flag = 1;		// 短押し
	if ((tm >= 300) && (tm < 1000)) flag = 2;	// ベタ押し
	return flag;
}

int SWPBF = 0, SWPBFD = 0;
unsigned long stup, stdw;

int StateUpSW() {		// 押されて1.5秒以内はdelay(200)あり、以降はなし
	int flag = 0;

  if ((GetSWstate() & 2) == 0) {	// Up SW が押されている
    if (SWPBF == 0) {
      SWPBF = 1; stup = millis(); //押し始め
      delay(200); flag = 1;
    } else {  //連続して押されている
      if ((millis() - stup) <= 1500) delay(200);
      flag = 1;
    }
  } else {  //押されてない
    SWPBF = 0; flag = 0;
  }

	return flag;
}

int StateDwSW() {		//  押されて1.5秒以内はdelay200)あり、以降はなし
  int flag = 0;

  if ((GetSWstate() & 1) == 0) {	// Up SW が押されている
    if (SWPBFD == 0) {
      SWPBFD = 1; stdw = millis(); //押し始め
      delay(200); flag = 1;
    } else {  //連続して押されている
      if ((millis() - stdw) <= 1500) delay(200);
      flag = 1;
    }
  } else {  //押されてない
    SWPBFD = 0; flag = 0;
  }

	return flag;
}

void EditFixTmMesData() { //定時通報のための時間を編集する
  //=========== TmStartの編集 ==========
  display(0, 15, "TmStartの編集\n0～1439の値です\n単位は分です。");
  canvas.setFont(&fonts::lgfxJapanMincho_32); // 明朝体（8,12,16,20,24,28,32,36,40）
  int tmst = TmStart;
  while(StateSetSW(0) != 3) { //SET 2秒押しで次へ
    tmst = (tmst/=5) * 5; //要は5の倍数にする
    if (StateUpSW() == 1) {tmst+=5; if (tmst >= 1435) tmst = 1435; }
    if (StateDwSW() == 1) {tmst-=5; if (tmst <= 5) tmst =0; }
    canvas.fillRect(0, 90, 160, 128, TFT_BLACK);  //数値行クリア
    canvas.setCursor(50, 90);
    canvas.printf("%d",tmst);
    canvas.pushSprite(0, 0);    //SpriteをLCDへ転送
  }
  //=========== TmIntervalの編集 ==========
  display(0, 15, "TmIntervalの編集\n5～1440の値です\n単位は分です。");
  canvas.setFont(&fonts::lgfxJapanMincho_32); // 明朝体（8,12,16,20,24,28,32,36,40）
  int tmint = TmInterval;
  while(StateSetSW(0) != 3) { //SET 2秒押しで次へ
    tmint = (tmint/=5) * 5; //要は5の倍数にする
    if (StateUpSW() == 1) {tmint+=5; if (tmint >= 1440) tmint = 1440; }
    if (StateDwSW() == 1) {tmint-=5; if (tmint <= 5) tmint = 5; }
    canvas.fillRect(0, 90, 160, 128, TFT_BLACK);  //数値行クリア
    canvas.setCursor(50, 90);
    canvas.printf("%d",tmint);
    canvas.pushSprite(0, 0);    //SpriteをLCDへ転送
  }

  display(0, 15, "編集値を保存\nYesはUp Keyを\nNoはDown Keyを\n押してく下さい");
  while ((GetSWstate() & 7) != 7) {} //すべての SW OFF を待つ(注! OFFで1)
  delay(100);

  while ((GetSWstate() & 3) == 3) {} //SW Press を待つ

  if (ChkSWNoChatt(1, 10)) {  // ↑ Key Press(1st bit) 10ms
    TmStart = tmst; TmInterval = tmint; Reserve = 0;  //本来の変数に代入
    saveParameters(TmStart, TmInterval, Reserve);
    display(0, 30, "TmStartと\nTmIntervalを\n保存しました。");
  } else {
    display(0, 25, "編集値を\n廃棄しました。\n元のままです。");
  }
  delay(5000);
}

//======= ＰＣとの通信で secrets.dat と parameter.dat の編集をする =======
void exe_command();
#define BUF_SIZE 512
volatile bool CMDflag = false;  // コマンド受信フラグ
char rxBuf[BUF_SIZE];           // 受信バッファ
int bufIdx = 0;                 // バッファの位置
int numNetworks = 0; // ← 先に宣言


//電源ONの時、SET_SWが5秒間押すとsectrts.datとparameter.datの編集入る
void EditImportantData() {
  // ===== SET,UP,DOWN 3 SWが全て押されていると初期化 =====
  // Flashを出荷状態に初期化する(真っ新のFlashに使うファイルの初期値を書き込む)
  if (ChkAllSWPress(100)) {  //SET,UP,DOWN 3つのSWが全て押されていると初期化
    display(10, 15, "Flashを\n出荷状態に\n初期化します。");
    saveSecrets(ssid, password, token);
    saveParameters(TmStart, TmInterval, Reserve);
    saveVersion();
    saveNoLineFlg(0);
    delay(5000);
  }

  // ===== sectrts.datとparameter.datのＰＣからの編集 =====
  display(0, 20, "重要データの\n編集モードです。\nＰＣのアプリを\n起動してください");
  while (true) {
    while (Serial.available()) {    // 受信データがある場合
      char c = Serial.read();       // 1文字取得
      bool BufStat = (bufIdx >= BUF_SIZE - 1);
      if (c == '\r' || BufStat) {   // CRまたはバッファ満了
        rxBuf[bufIdx] = '\0';       // 文字列終端
        CMDflag = true;       // コマンド受領フラグを立てる
        bufIdx = 0;           // バッファリセット
        if (BufStat) {
          digitalWrite(LED, HIGH); //LED点灯(警報)
          BufStat = false;
          display(0, 40, "受信Bufferが不足\n"
                         "しています！");
        }
      } else {
        rxBuf[bufIdx++] = c;  // バッファに追加
      }
    }
    exe_command();
    if (StateSetSW(1) == 3) break;  //SET SW 5秒押しで抜ける
  }
}

void DispVariable() {
  Serial.print("SSID: "); Serial.println(ssid);
  Serial.print("Password: "); Serial.println(password);
  Serial.print("Token: "); Serial.println(token);
  Serial.print("TmStart: "); Serial.println(TmStart);
  Serial.print("TmInterval: "); Serial.println(TmInterval);
  Serial.print("Reserve: "); Serial.println(Reserve);
}

void dspHelp(void) {  // Help、メニューの表示
   Serial.printf("Tx |Test:0~3\n");
   Serial.printf("Bx |DispTest:0~3\n");
   Serial.printf("WS |WR secrets.dat\n");
   Serial.printf("WP |WR parameter.dat\n");
   Serial.printf("RS |RD secrets.dat\n");
   Serial.printf("RP |RD parameter.dat\n");
   Serial.printf("V  |Version\n");
   Serial.printf("A  |Response\n");
   Serial.printf("?  |Help\n");
}

void dspnsup(void) {  // サポートしていないコマンドの場合に表示する
   Serial.println("?");
}

//================  コマンドの実行処理  ================
void exe_command(void) {
  String RD;
  char* first;
  char* second;
  char* third ;
  /*char* p;  //【 学習 】
    char * p;
    char *p;
  上記の3種類は間違いなくどれも同じ意味てす。*/

  char *p, c;
  if (CMDflag == false) return; // コマンドを受信していなければ、即リターン
  p = rxBuf;
  switch(c = toupper(*p++)) {   // 最初の一文字を取り出す(c)
    case 'T':   // for Test
        switch(c = toupper(*p++)) {
          case '0': //RPI-PicoWの入力全部の読み込み(C言語によるPIC・・P246)
              gpio_state = sio_hw->gpio_in; //または、(*sio_hw).gpio_in
              Serial.printf("GPIO_IN: 0x%08lX\n", gpio_state);  //HEX表示
              Serial.print("GPIO_IN: ");        //入力のバイナリ表示
              for (int i = 29; i >= 0; i--) {   // 上位ビットから順に表示
                Serial.print((gpio_state >> i) & 1);
              }
              Serial.println();
              break;
          case '1': Serial.printf("2:%s\n", BOOL_TO_STRING(ChkSWNoChatt(2,10)));
                    Serial.printf("1:%s\n", BOOL_TO_STRING(ChkSWNoChatt(1,10)));
                    Serial.printf("0:%s\n", BOOL_TO_STRING(ChkSWNoChatt(0,10)));
                    /*t1        対象bitが10ms以上押されているとtrueを返す
                      2:false
                      1:true
                      0:false*/
              break;
          case '2': DispVariable();
                    Serial.println("----- ここで読み込む -----");
                    loadSecrets();      //WiFiその他の接続用データ取得
                    loadParameters();   //定時通報・その他のデータ取得
                    DispVariable();
              break;
          /*参考：RSSI の目安
            RSSI値 (dBm)  信号強度の目安  接続安定性
            -30〜-50	  非常に良好       ◎ 安定・高速
            -51〜-70    	良好	       ◯ 十分実用的
            -71〜-85	弱いが接続可能	   △ 通信が不安定なことも
            -86〜	      非常に弱い	   × 接続不可・不安定
            なので、-91dBm のアクセスポイントに繋がらないのは、正常です。*/
          case '3': WiFi.mode(WIFI_STA);     //ステーションモードにしておく(スキャンするため)
                    WiFi.disconnect();       //接続解除してスキャン可能な状態にする
                    delay(100);

                    Serial.println("WiFi スキャン開始...");

                    numNetworks = WiFi.scanNetworks();  // グローバル変数に代入

                    if (numNetworks == 0) {
                      Serial.println("ネットワークが見つかりませんでした。");
                    } else {
                      Serial.print("見つかったネットワーク数: ");
                      Serial.println(numNetworks);
                      for (int i = 0; i < numNetworks; ++i) {
                        Serial.print(i + 1);
                        Serial.print(": ");
                        Serial.print(WiFi.SSID(i));        // SSID
                        Serial.print(" (RSSI: ");
                        Serial.print(WiFi.RSSI(i));        // 信号強度（dBm）
                        Serial.print("dBm) ");
                        Serial.println(WiFi.encryptionType(i) == 
                                                    CYW43_AUTH_OPEN ? "[OPEN]" : "[SECURED]");
                        delay(10);
                      }
                    }
                break;
          default : dspnsup(); break;
        } 
        break;
    case 'B':    //各種表示(写真撮影用)
        switch(c = toupper(*p++)) {
          case '0': display(0, 15, "WiFi接続が失敗!\nリブートします。\n"
                      "SSID,passwordの\n再確認が必要かも\nしれません。");
              break;
          case '1': display(0, 40, "LINEへメッセージを送っています。");
              break;
          case '2': display(0, 40, "WiFi への接続を実行しています。");
              break;
          case '3': display(0, 20, "重要データの\n編集モードです。"
                                 "\nＰＣのアプリを\n起動してください");
              break;
          default : dspnsup(); break;
        } 
        break;              
    case 'W':    //各種の書き込み
      switch(c = toupper(*p++)) {
        case 'S':   //コマンドWS、PCからのsecretsデータの保存コマンド
              first = strtok(p, "\n");
              second = strtok(NULL, "\n");
              third = strtok(NULL, "\n");

              if (first && second && third) {
                ssid     = String(first);     //|原本の変数|
                password = String(second);    //|を、ここで|
                token    = String(third);     //|書き換える|
              } else {
                Serial.println("Data Format Error !");
                digitalWrite(LED, HIGH); //LED点灯(警報)
              }
              saveSecrets(ssid, password, token); //原本の変数をファイルへ保存
              Serial.println("OK");   //応答を返す
              digitalWrite(LED, LOW); //LED消灯
              break;
        case 'P':   //コマンドWS、PCからのparameterデータの保存コマンド
              first = strtok(p, ",");
              second = strtok(NULL, ",");
              third = strtok(NULL, "\r");

              if (first && second && third) {
                TmStart    = atoi(first);     //|原本の変数|
                TmInterval = atoi(second);    //|を、ここで|
                Reserve    = atoi(third);     //|書き換える|
              } else {
                Serial.println("Data Format Error !");
                digitalWrite(LED, HIGH); //LED点灯(警報)
              }
              saveParameters(TmStart, TmInterval, Reserve); //原本の変数をファイルへ保存
              Serial.println("OK");   //応答を返す
              digitalWrite(LED, LOW); //LED消灯
              break;
      } 
      break;
    case 'R':    //各種の読み出し
      switch(c = toupper(*p++)) {
        case 'S': file = LittleFS.open("/secrets.dat", "r");  //secrets.datの読み出し
              if (!file) {
                  Serial.println("Failed to open file for reading");
                  digitalWrite(LED, HIGH); //LED点灯(警報)
                  return;
              }
              RD = file.readString();
              RD.replace("\r", "");     //区切り"\r\n"から"\n"になった
              Serial.print(RD);
              Serial.print('\r');
              file.close();
              digitalWrite(LED, LOW); //LED消灯
              break;
        case 'P': file = LittleFS.open("/parameter.dat", "r");  //parameter.datの読み出し
              if (!file) {
                  Serial.println("Failed to open file for reading");
                  digitalWrite(LED, HIGH); //LED点灯(警報)
                  return;
              }
              RD = file.readStringUntil('\r');
              Serial.print(RD);
              Serial.print('\r');
              file.close();
              digitalWrite(LED, LOW); //LED消灯
              break;
      } 
      break;
    case 'A': Serial.println("Z"); break; // 通信確立の確認用
    case 'V': Serial.println(FileVersion); break; // バージョン表示
    case '?': dspHelp(); break;           // Help、メニューの表示
    default : dspnsup(); 
              break;
  }
  bufIdx = 0;        // 受信文字数をクリアする
  CMDflag = false;   // コマンド受信フラグをクリアする
}
